local assets=
{
	Asset("ANIM", "anim/emtool.zip"),
	Asset("ANIM", "anim/swap_emtool.zip"),
	
	Asset("IMAGE", "images/inventoryimages/emtool.tex"),
	Asset("ATLAS", "images/inventoryimages/emtool.xml"),
}

--local function onfinished(inst)
--    inst:Remove()
--end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_emtool", "swap_emtool")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end

local function onAttack(inst,holder,target)
	--print("DMPA "..t3.prefab.." "..t1.prefab)
	inst.EElastAttacked = target.prefab
	if target.EEmobexchanged and target.EEmobexchanged == true then
		holder.components.health.currenthealth = holder.components.health.currenthealth - 50
		holder.components.health:DoDelta(0,nil,"EM Multitool")
		holder.components.sanity:DoDelta(-75)
	end
end

local function OnSave(inst, data)
	if inst.EElastAttacked then
		data["EElastAttacked"] = inst.EElastAttacked
	end
end

local function OnLoad(inst, data)
    if data and data["EElastAttacked"] then
		inst.EElastAttacked = data["EElastAttacked"]
		print("DM pickaxe: "..data["EElastAttacked"])
	end
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("emtool")
    anim:SetBuild("emtool")
    anim:PlayAnimation("idle",true)
    
    inst:AddTag("sharp")
    
    inst:AddComponent("weapon")
	if EEDEBUG == true then
		inst.components.weapon:SetDamage(10000)
	else
		inst.components.weapon:SetDamage(350)
	end
	inst.components.weapon:SetOnAttack(onAttack)
	
    -----
    inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.CHOP, 5)
	inst.components.tool:SetAction(ACTIONS.MINE, 5)
	inst.components.tool:SetAction(ACTIONS.HAMMER)
	inst.components.tool:SetAction(ACTIONS.DIG)
	
    -------
    
    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "emtool"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/emtool.xml"
    inst.components.inventoryitem:GetImage()
    inst.components.inventoryitem:GetAtlas()
    
    inst:AddComponent("equippable")

    inst.components.equippable:SetOnEquip( onequip )
    
    inst.components.equippable:SetOnUnequip( onunequip)

    
    return inst

end

return Prefab( "common/inventory/emtool", fn, assets)

